
<?php

#********************************************************************************
#If you should have any comments, suggestions or improvements to these samples,
#we welcome you to contact us at SampleCode@melissadata.com also please visit our
#developers bulletin board at forum.melissadata.com.
#********************************************************************************

include './php_mdPhonePHP7Wrapper.php';

//********************** LICENSE STRINGS ************************
//*      To unlock the full functionality of Global Phone       *
//*  and/or Phone Object Or to obtain a Demo License String     *
//* please call a sales representative at 1-800-MELISSA ext. 3  *
//*         (1-800-635-4772 x3) for a license string.           *
//**************************************************************/

#Put License and Directory of Global PHone and/or Phone Object Data Files here
$License = "Place License String Here";
$DataPath = "C:\Program Files\Melissa Data\DQT\Data";

print "Enter 'G' if you would like to test the Global Phone Object, or 'P' if you would like to test the Phone Object: \n";
$objChar = trim(fgets(STDIN));

$ResultsString = "";

if($objChar == "G")
{
	#Create new Global Phone Object
	$GlobalPhoneObj = new mdGlobalPhone();
	
	#Set the license string
	$GlobalPhoneObj->SetLicenseString($License);
	
	#Initialize object
	if($GlobalPhoneObj->Initialize($DataPath) != 0)
	{
		print "Cannot initialize: " .$GlobalPhoneObj->GetInitializeErrorString()."\n";
		exit;
	}
	
	# Print Initialized Information
	print "\n";
	print " Global Phone Obj Build Number: ".$GlobalPhoneObj->GetBuildNumber()."\n";
	
	#Get Input for Global Phone Obj
	print "**** Global Phone inputs ****";
	print "Enter Global telephone number (ex 422304850): ";
	$globalPhoneNumbr = trim(fgets(STDIN));
	print "                 Enter country name (ex JPN): ";
	$globalCountry = trim(fgets(STDIN));
	print "            Enter country of origin (ex USA): ";
	$globalCountryOfOrigin = trim(fgets(STDIN));
	
	#Call the Lookup function
	$GlobalPhoneObj->Lookup($globalPhoneNumbr, $globalCountry, $globalCountryOfOrigin);
	
	#Store the Results Codes
	$ResultsString = $GlobalPhoneObj->GetResults();
	
	#Return the output fields
	print "\n========== Global Phone Obj Lookup Results ================\n\n";
    print "                         Phone Number: ". $GlobalPhoneObj->GetPhone(). "\n";
	print "                        Nation Prefix: ". $GlobalPhoneObj->GetNationPrefix(). "\n";
	print "					International Prefix: ". $GlobalPhoneObj->GetInternationalPrefix(). "\n";
	print "            National Destination Code: ". $GlobalPhoneObj->GetNationalDestinationCode(). "\n";
	print "                      Locality (City): ". $GlobalPhoneObj->GetLocality(). "\n";
	print           "Administrative Area (State): ". $GlobalPhoneObj->GetAdministrativeArea(). "\n";
	print "                              Country: ". $GlobalPhoneObj->GetCountry(). "\n";
	print "Observes Daylight Savings Time (DST)?: ". $GlobalPhoneObj->GetDST(). "\n";
	print "                             Language: ". $GlobalPhoneObj->GetLanguage(). "\n";
	print "                             Latitude: ". $GlobalPhoneObj->GetLatitude(). "\n";
	print "                            Longitude: ". $GlobalPhoneObj->GetLongitude(). "\n";
	print "                    Subscriber Number: ". $GlobalPhoneObj->GetSubscriberNumber(). "\n";
	print "                                  UTC: ". $GlobalPhoneObj->GetUTC(). "\n";
}
else
{
	#Create new Phone Object
	$PhoneObj = new mdPhone();


	#Set License String
	$PhoneObj->SetLicenseString($License);


	#Initialize the object
	if($PhoneObj->Initialize($DataPath) != 0)
	{
		print "Cannot Initialize: ".$PhoneObj->GetInitializeErrorString()."\n";
		exit;
	}

	# Print Initialized Information
	print "\n";
	print " Phone Obj Build Number: " .$PhoneObj->GetBuildNumber()."\n";



	#Get Input for Phone Obj
	print "*** Phone Obj inputs ***";
	print "Enter Telephone Number: ";
	$phone = trim(fgets(STDIN));
	print "        Enter Zip Code: ";
	$zip = trim(fgets(STDIN));


	print "\n";

	#Call the Lookup function
	$PhoneObj->Lookup($phone,$zip);
	
	#Store the Results Codes
	$ResultsString = $PhoneObj->GetResults();

	
	#Return the output fields
		  print "\n========== Phone Obj Lookup Results ================\n\n";
		  print "    Area Code: ". $PhoneObj->GetAreaCode(). "\n";
		  print "       Prefix: ". $PhoneObj->GetPrefix(). "\n";
		  print "       Suffix: ". $PhoneObj->GetSuffix(). "\n";
		  print "         City: ". $PhoneObj->GetCity(). "\n";
		  print "        State: ". $PhoneObj->GetState(). "\n";
		  print "  County Name: ". $PhoneObj->GetCountyName(). "\n";
		  print "  County FIPS: ". $PhoneObj->GetCountyFips(). "\n";
		  print " Country Code: ". $PhoneObj->GetCountryCode(). "\n";
		  print "     TimeZone: ". $PhoneObj->GetTimeZone(). "\n";
		  print "TimeZone Code: ". $PhoneObj->GetTimeZoneCode(). "\n";
		  print "          MSA: ". $PhoneObj->GetMsa(). "\n";
		  print "         PMSA: ". $PhoneObj->GetPmsa(). "\n";
		  print " Results Code: ". $PhoneObj->GetResults(). "\n\n";

		  $Latitude = $PhoneObj->GetLatitude();
		  $Longitude = $PhoneObj->GetLongitude();
		  print "     Latitude: ". $Latitude. "\n";
		  print "    Longitude: ". $Longitude. "\n";

		  print "\n";
		  print "==================================================\n";
		  print " Compute Distance and Bearing to another location\n";
		  print " Lat / Long of US Capital: 38.889722  -77.0075 \n";
		  print "==================================================\n";
		  print "     Distance : ". $PhoneObj->ComputeDistance($Latitude, $Longitude, 38.889722, -77.0075). " miles\n";
		  print "      Bearing : ". $PhoneObj->ComputeBearing($Latitude, $Longitude, 38.889722, -77.0075). " degrees\n"; 
	   
	if($zip != "")
	{
		$PhoneObj->CorrectAreaCode($phone,$zip);
		print "\n========== Correct Area Code Results =============\n\n";
		print " Results Code: ". $PhoneObj->GetResults(). "\n";
		print "    Area Code: ". $PhoneObj->GetAreaCode(). "\n";
		print "New Area Code: ". $PhoneObj->GetNewAreaCode(). "\n";
		print "       Prefix: ". $PhoneObj->GetPrefix(). "\n";
		print "       Suffix: ". $PhoneObj->GetSuffix(). "\n";
		print "    Extension:  ". $PhoneObj->GetExtension(). "\n\n";

	}
}

#Return the descriptions of the Results Codes
print "\n========== Lookup Results Codes ================\n\n";
	if (strstr($ResultsString,"PE01") != false)
	   print "Error: Area Code Not valid\n";
	if (strstr($ResultsString,"PE02") != false)
	   print "Error: Blank Phone Number\n";
	if (strstr($ResultsString,"PE03") != false)
	   print "Error: Phone Number Not valid\n";
	if (strstr($ResultsString,"PE04") != false)
	   print "Error: Input has Multiple Matches\n";
	if (strstr($ResultsString,"PE05") != false)
	   print "Error: Phone Prefix Not Valid\n";
	if (strstr($ResultsString,"PE06") != false)
	   print "Error: Zip Code Not Valid\n";
	if (strstr($ResultsString,"PE08") != false)
	   print "Error: No country inputted\n";
	if (strstr($ResultsString,"PE09") != false)
	   print "Error: Subscriber number out of range\n";
	if (strstr($ResultsString,"PE10") != false)
	   print "Error: Bad country inputted\n";


	if (strstr($ResultsString,"PS01") != false)
	   print "  Validation: Validated to 10 Digits\n";
	elseif (strstr($ResultsString,"PS02") != false)
	   print "  Validation: Validated to 7 Digits\n";
	 
	if (strstr($ResultsString,"PS07") != false)
	   print "ExchangeType: Cellular\n";
	elseif (strstr($ResultsString,"PS08") != false)
	   print "ExchangeType: Land Line\n";  
	elseif (strstr($ResultsString,"PS09") != false)
	   print "ExchangeType: VOIP\n"; 
		   
	if (strstr($ResultsString,"PS10") != false)
	   print "   PhoneType: Residential\n";
	elseif (strstr($ResultsString,"PS11") != false)
	   print "   PhoneType: Business\n";  
	elseif (strstr($ResultsString,"PS12") != false)
	   print "   PhoneType: Small/Home Office\n";
	elseif (strstr($ResultsString,"PS13") != false)
	   print "   PhoneType: International toll-free number\n";
	elseif (strstr($ResultsString,"PS14") != false)
	   print "   PhoneType: International number with high charge rate\n";
			   
	if (strstr($ResultsString,"PS03") != false)
	   print "Status: Corrected area code";
	if (strstr($ResultsString,"PS04") != false)
	   print "Status: Phone number is outside the demo range\n";
	if (strstr($ResultsString,"PS05") != false)
	   print "Status: Database expired. Please contact a Melissa Data sales representative\n";
	if (strstr($ResultsString,"PS06") != false)
	   print "Status: Area code updated\n";
	if (strstr($ResultsString,"PE06") != false)
	   print "Error: Zip Code Not Valid\n";


?>
